IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[ADM_ERRO_EST_PED_VD]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[ADM_ERRO_EST_PED_VD](
	[CODIGO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PED] [int] NOT NULL,
 CONSTRAINT [PK_ADM_ERRO_EST_PED_VD] PRIMARY KEY CLUSTERED 
(
	[CODIGO] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PED] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD] ADD  CONSTRAINT [DF_ADM_ERRO_EST_PED_VD_CODIGO]  DEFAULT ((0)) FOR [CODIGO]

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD] ADD  CONSTRAINT [DF_ADM_ERRO_EST_PED_VD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD] ADD  CONSTRAINT [DF_ADM_ERRO_EST_PED_VD_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD] ADD  CONSTRAINT [DF_ADM_ERRO_EST_PED_VD_CD_PED]  DEFAULT ((0)) FOR [CD_PED]

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_PED_VD_ADM_ERRO_EST_PED_VD] FOREIGN KEY([CODIGO])
REFERENCES [dbo].[ADM_ERRO] ([CODIGO])

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD] CHECK CONSTRAINT [FK_ADM_ERRO_EST_PED_VD_ADM_ERRO_EST_PED_VD]

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_PED_VD_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED])
REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])

ALTER TABLE [dbo].[ADM_ERRO_EST_PED_VD] CHECK CONSTRAINT [FK_ADM_ERRO_EST_PED_VD_EST_PED_VD]
end